<?php
session_start();
if (isset($_SESSION["user_id"])) {
    if (isset($_GET["lnk"])) {
        $LinkReBase = base64_decode($_GET["lnk"]);
        header("Location: $LinkReBase");
    } else {
        header("Location: ChatMessage");
    }
    exit();
}
if (isset($_COOKIE["rememberme"])) {
    $_SESSION["user_id"] = $_COOKIE["rememberme"];
    header("Location: ChatMessage");
    exit();
}
?>
<!DOCTYPE html>
<html lang="fa">
  <head>
    <meta http-equiv="content-type" content="text/html;charset=UTF-8" />
    <link rel="dns-prefetch" href="http://dr-bahraini.ir/" />
    <link rel="dns-prefetch" href="http://fonts.googleapis.com/" />
    <title>ورود | پیام رسان اختصاصی گروه مشاوره سیامک حیدری</title>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width,initial-scale=1" />
    <meta name="author" content="NovaGolden" />
        <meta name="theme-color" content="#dde9f3"/>
    <!-- Windows Phone -->
<meta name="msapplication-navbutton-color" content="#dde9f3">
<!-- iOS Safari -->
<meta name="apple-mobile-web-app-status-bar-style" content="#dde9f3">
    <link rel="icon" href="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/favicon/favicon.png" type="image/x-icon" />
    <link rel="shortcut icon" href="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/favicon/favicon.png" type="image/x-icon" />
    <link href="https://fonts.googleapis.com/css?family=Montserrat:400,500,600,700,800&amp;display=swap" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css?family=Roboto:400,500,600&amp;display=swap" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css?family=Rubik:300,300i,400,400i,500,500i,700,700i,900,900i&amp;display=swap" rel="stylesheet" />
    <link rel="stylesheet" type="text/css" href="https://app2.drsiamakheydari.ir/chit_chat/rtl/css/style.css" media="screen" id="color" />
    <link rel="stylesheet" href="https://app2.drsiamakheydari.ir/chit_chat/rtl/css/chitChat.css" />
    <link rel="stylesheet" href="https://app2.drsiamakheydari.ir/chit_chat/libs/font-awesome/4.7.0/css/font-awesome.min.css" />
    <link rel="stylesheet" href="https://app2.drsiamakheydari.ir/fonts/vazir/Farsi-Digits/Vazirmatn-FD-font-face.css" />
    <style>
      .form-group input::placeholder {
        text-align: right;
        direction: rtl;
      }
      .form-group input {
        text-align: left;
        direction: ltr;
      }
      .termscondition h4 {
        text-align: center;
      }
      .login-page1 {
        height: unset;
        overflow-x: hidden;
      }
      body {
        overflow-y: auto;
      }
      .login-page1 .login-contain-main {
        height: unset;
      }
    </style>
  </head>
  <body class="rtl">
    <div class="login-page1">
      <div class="container-fluid p-0">
        <div class="row">
          <div class="col-12">
            <div class="login-contain-main">
              <div class="left-page">
                <div class="login-content">
                  <div class="login-content-header">
                    <!--<img class="image-fluid" src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/logo/landing-logo.png" alt="images" /> -->
                    <h1 style="margin-bottom: 20px;">گروه مشاوره دکتر سیامک حیدری</h1>
                  </div>
                  <h3>امن و سریع برای داوطلبان عزیز !</h3>
                  <h4>برای وارد شدن به گروه خود، اطلاعات را وارد کنید.</h4>
                  <form class="form1" method="post" action="" name="signin-form">
                    <div class="form-group">
                      <label class="col-form-label" for="UID">شناسه داوطلب</label>
                      <input class="form-control" name="UID" id="UID" type="number" placeholder="شناسه داوطلبی خود را وارد کنید." />
                    </div>
                    <div class="form-group">
                      <label class="col-form-label" for="UPW">کلمه عبور داوطلب</label>
                      <span></span>
                      <input class="form-control" name="UPW" id="UPW" type="password" placeholder="کلمه عبور خود را وارد کنید." />
                    </div>
                    <?php
include "ChatConfig.php";
if (isset($_POST["login"])) {
    $username = $_POST["UID"];
    $password = $_POST["UPW"];
    $query = $connection->prepare(
        "SELECT * FROM users WHERE username=:username"
    );
    $query->bindParam("username", $username, PDO::PARAM_STR);
    $query->execute();
    $result = $query->fetch(PDO::FETCH_ASSOC);
    if (!$result) {
        echo '<p class="error">اطلاعات وارد شده نادرست است ! لطفا مجدد بررسی کنید.</p>';
    } else {
        if (password_verify($password, $result["password"])) {
            if ($result["number"] == "0") {
                echo '<p class="error">دسترسی به این حساب کاربری محدود و غیر مجاز است!</p>';
            } else {
                $_SESSION["user_id"] = $result["id"];
                echo '<p class="error">ورود شما موفق آمیز بود ! در حال انتقال به گروه هستید . . .</p>';
                $secondsWait = 1;
                echo '<meta http-equiv="refresh" content="' .
                    $secondsWait .
                    '" style="display: none;">';
            }
        } else {
            echo '<p class="error">اطلاعات وارد شده نادرست است ! لطفا مجدد بررسی کنید.</p>';
        }
    }
}
?>
                    <div class="form-group">
                      <div class="buttons d-flex">
                        <button class="btn btn-primary button-effect" type="submit" name="login" value="login">ورود به گروه</button>
                      </div>
                    </div>
                  </form>
                  <div class="termscondition">
                    <h4 class="mb-0">ساخته شده با ❤ توسط تیم نوا گلدن !</h4>
                  </div>
                </div>
              </div>
              <div class="right-page">
                <div class="right-login animat-rate">
                  <div class="animation-block">
                    <div class="bg_circle">
                      <div></div>
                      <div></div>
                      <div></div>
                      <div></div>
                      <div></div>
                      <div></div>
                      <div></div>
                      <div></div>
                      <div></div>
                      <div></div>
                      <div></div>
                    </div>
                    <div class="cross"></div>
                    <div class="cross1"></div>
                    <div class="cross2"></div>
                    <div class="dot"></div>
                    <div class="dot1"></div>
                    <div class="maincircle"></div>
                    <div class="top-circle"></div>
                    <div class="center-circle"></div>
                    <div class="bottom-circle"></div>
                    <div class="bottom-circle1"></div>
                    <div class="right-circle"></div>
                    <div class="right-circle1"></div>
                    <img class="heart-logo" src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/login_signup/5.png" alt="login logo" />
                    <img class="has-logo" src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/login_signup/4.png" alt="login logo" />
                    <img class="login-img" src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/login_signup/1.png" alt="login logo" />
                    <img class="boy-logo" src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/login_signup/6.png" alt="login boy logo" />
                    <img class="girl-logo" src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/login_signup/7.png" alt="girllogo" />
                    <img class="cloud-logo" src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/login_signup/2.png" alt="login logo" />
                    <img class="cloud-logo1" src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/login_signup/2.png" alt="login logo" />
                    <img class="cloud-logo2" src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/login_signup/2.png" alt="login logo" />
                    <img class="cloud-logo3" src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/login_signup/2.png" alt="login logo" />
                    <img class="cloud-logo4" src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/login_signup/2.png" alt="login logo" />
                    <img class="has-logo1" src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/login_signup/4.png" alt="login logo" />
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </body>
</html>